<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id'])) {
    header('Location: eleves.php');
}

$id = $_GET['id'];

if (isset($_GET['supprimer'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare("DELETE FROM eleve WHERE id_eleve=:id");
        $requete->bindParam(':id', $id);
        $requete->execute();
        $bdd->commit();

        header('Location: eleves.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('UPDATE eleve SET nom=:nom, prenom=:prenom, naissance=:naissance, sexe=:sexe, inscription=:inscription, etablissement_precedent=:etablissement_precedent, num_rue=:num_rue, cp=:cp, ville=:ville, tel_domicile=:tel_domicile, tel_mobile=:tel_mobile, matricule=:matricule WHERE id_eleve=:id');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':prenom', $_POST['prenom']);
        $requete->bindParam(':naissance', $_POST['naissance']);
        $requete->bindParam(':sexe', $_POST['sexe']);
        $requete->bindParam(':inscription', $_POST['inscription']);
        $requete->bindParam(':etablissement_precedent', $_POST['etablissement']);
        $requete->bindParam(':num_rue', $_POST['adresse']);
        $requete->bindParam(':cp', $_POST['cp']);
        $requete->bindParam(':ville', $_POST['ville']);
        $requete->bindParam(':tel_domicile', $_POST['fixe']);
        $requete->bindParam(':tel_mobile', $_POST['portable']);
        $requete->bindParam(':matricule', $_POST['matricule']);
        $requete->bindParam(':id', $id);
        $requete->execute();

        if ($_POST['id_resp'] != '') {
            $requete = $bdd->prepare('UPDATE responsable SET id_eleve=:id WHERE id=:id_resp');
            $requete->bindParam(':id', $id);
            $requete->bindParam(':id_resp', $_POST['id_resp']);
            $requete->execute();
        }

        $bdd->commit();

        header('Location: eleves.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}

$requete = $bdd->prepare("SELECT * FROM eleve WHERE id_eleve=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$eleve = $requete->fetch();

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Modification d'un élève - <a href="edition-eleve.php?id=<?php echo htmlspecialchars($id) ?>&supprimer">Supprimer cet eleve</a> </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom" value="<?php echo htmlspecialchars($eleve['nom']) ?>">
                                    <label>Prénom</label>
                                    <input class="form-control" name="prenom" value="<?php echo htmlspecialchars($eleve['prenom']) ?>">
                                    <label>Date de naissance</label>
                                    <input class="form-control" name="naissance" placeholder="AAAA-MM-JJ" value="<?php echo htmlspecialchars($eleve['naissance']) ?>">
                                    <label>Sexe</label>
                                    <input class="form-control" name="sexe" placeholder="M/F" value="<?php echo htmlspecialchars($eleve['sexe']) ?>">
                                    <label>Date d'inscription</label>
                                    <input class="form-control" name="inscription" placeholder="AAAA-MM-JJ" value="<?php echo htmlspecialchars($eleve['inscription']) ?>">
                                    <label>Etablissement précédent</label>
                                    <input class="form-control" name="etablissement" value="<?php echo htmlspecialchars($eleve['etablissement_precedent']) ?>">
                                    <label>Responsable</label>
                                    <select class="form-control" name="id_resp">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT id, nom_responsable, prenom_responsable, id_eleve FROM responsable");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id']).'">'.htmlspecialchars($row['prenom_responsable'].' '.$row['nom_responsable']).'</option>';
                                        ?>
                                    </select>
                                    <label>Adresse</label>
                                    <input class="form-control" name="adresse" value="<?php echo htmlspecialchars($eleve['num_rue']) ?>">
                                    <label>Code postal</label>
                                    <input class="form-control" name="cp" value="<?php echo htmlspecialchars($eleve['cp']) ?>">
                                    <label>Ville</label>
                                    <input class="form-control" name="ville" value="<?php echo htmlspecialchars($eleve['ville']) ?>">
                                    <label>Téléphone fixe</label>
                                    <input class="form-control" name="fixe" value="<?php echo htmlspecialchars($eleve['tel_domicile']) ?>">
                                    <label>Téléphone portable</label>
                                    <input class="form-control" name="portable" value="<?php echo htmlspecialchars($eleve['tel_mobile']) ?>">
                                    <label>Matricule</label>
                                    <input class="form-control" name="matricule" value="<?php echo htmlspecialchars($eleve['matricule']) ?>">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
